﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP_WEB.BaseCode;
using VIRP_WEB.SoaServices;
using AntiXssEnc = Microsoft.Security.Application;

namespace VIRP_WEB.Controls.Survey
{
    public partial class SurveyQuestionDescription : System.Web.UI.UserControl
    {
        public List<SURVEY_RESULTS> Questions { get; set; }
        
        protected void Page_Load(object sender, EventArgs e)
        {
        }

        public void BuildQuestion()
        {
            SURVEY_RESULTS question = Questions.First();
            STD_QUESTION stdQuestion = Questions.First().STD_QUESTION;

            string validatedQuestionText = AntiXssEnc.Encoder.HtmlEncode(stdQuestion.QUESTION_TEXT);
            validatedQuestionText = validatedQuestionText.Replace("&#10;", "<BR>");

            lblQuestion.ID = "lbl" + stdQuestion.ID.ToString();
            if (!string.IsNullOrEmpty(AntiXssEnc.Encoder.HtmlEncode(stdQuestion.QUESTION_NUMBER)))
                lblQuestion.Text = AntiXssEnc.Encoder.HtmlEncode(stdQuestion.QUESTION_NUMBER) + ") " + validatedQuestionText;
            else
                lblQuestion.Text = validatedQuestionText;
        }

        public string BuildNoteTemplate()
        {
            StringBuilder sbNote = new StringBuilder();

            SURVEY_RESULTS question = Questions.First();
            STD_QUESTION stdQuestion = Questions.First().STD_QUESTION;

            lblQuestion.ID = "lbl" + stdQuestion.ID.ToString();
            if (!string.IsNullOrEmpty(stdQuestion.QUESTION_NUMBER))
            {
                string strQuestion = stdQuestion.QUESTION_NUMBER + ") " + stdQuestion.QUESTION_TEXT;
                sbNote.AppendLine("*" + strQuestion);
            }
            else
            {
                string strQuestion = stdQuestion.QUESTION_TEXT;
                sbNote.AppendLine("*" + strQuestion);
            }

            return sbNote.ToString();
        }
    }
}